package empty

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestDecoder(t *testing.T) {
	dec := NewDecoder()
	assert.Equal(t, method, dec.Method())

	t.Run("should allow empty codes", func(t *testing.T) {
		r, ok := dec.Decode(nil)
		assert.True(t, ok)
		assert.Equal(t, req, r)
	})

	t.Run("should not allow non-empty codes", func(t *testing.T) {
		r, ok := dec.Decode(OpaqueBytes("x"))
		assert.False(t, ok)
		assert.Nil(t, r)
	})
}
