package empty

import (
	"net/http"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
)

func TestExtractor(t *testing.T) {
	ext := NewExtractor()
	assert.Equal(t, method, ext.Method())

	t.Run("should allow empty headers", func(t *testing.T) {
		header := http.Header{}
		r, ok := ext.Extract(header)
		assert.True(t, ok)
		assert.Equal(t, req, r)
		assert.NoError(t, ext.FailureReason(header))
	})

	t.Run("should reject any authorization header", func(t *testing.T) {
		header := http.Header{}
		header.Set(protocol.HTTPAuthorizationHeader, "x")
		r, ok := ext.Extract(header)
		assert.False(t, ok)
		assert.Nil(t, r)
		assert.Equal(t, stream.ErrExpectedAnonymousRequest, ext.FailureReason(header))
	})
}
