package empty

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestResolver(t *testing.T) {
	res := NewResolver()
	assert.Equal(t, method, res.Method())

	creds, err := res.Resolve(nil)
	assert.Nil(t, creds)
	assert.Equal(t, stream.ErrExpectedAnonymousRequest, err)

	creds, err = res.Resolve(NewRequest())
	assert.Equal(t, stream.NoPermissions(), creds)
	assert.NoError(t, err)
}
