package extjwt

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestAuthSource(t *testing.T) {
	token := testToken(&claims{})

	t.Run("should pass parameters as expected", func(t *testing.T) {
		src := NewAuthSource(clientID, func() OpaqueBytes { return token })
		req := src()
		assert.Equal(t, method, req.Method())
		code := req.Encode()
		assert.Equal(t, OpaqueBytes(strings.Join([]string{method, clientID, string(token)}, delimiter)), code)
	})
}
