package extjwt

import (
	"strings"

	"code.justin.tv/common/jwt"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type decoder struct{}

var decSingleton = &decoder{}

func NewDecoder() auth.Decoder { return decSingleton }

func (*decoder) Method() string { return method }
func (*decoder) Decode(code OpaqueBytes) (stream.AuthRequest, bool) {
	seg := strings.Split(string(code), delimiter)
	if len(seg) != 3 || seg[0] != method || seg[1] == "" {
		return nil, false
	}
	token := OpaqueBytes(seg[2])
	if _, err := jwt.Parse(token); err != nil {
		return nil, false
	}
	return NewRequest(seg[1], token), true
}
