package extjwt

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestDecoder(t *testing.T) {
	dec := NewDecoder()
	validToken := testToken(&claims{})

	t.Run("should allow valid tokens", func(t *testing.T) {
		req, ok := dec.Decode(NewRequest(clientID, validToken).Encode())
		require.NotNil(t, req)
		assert.Equal(t, &request{clientID, validToken}, req)
		assert.True(t, ok)
	})

	t.Run("should report its method correctly", func(t *testing.T) {
		assert.Equal(t, method, dec.Method())
	})

	t.Run("should return false when malformed code is provided", func(t *testing.T) {
		req, ok := dec.Decode(OpaqueBytes("what"))
		assert.Nil(t, req)
		assert.False(t, ok)
	})

	t.Run("should fail when no Client-ID is provided", func(t *testing.T) {
		req, ok := dec.Decode(OpaqueBytes(strings.Join([]string{method, "", string(validToken)}, delimiter)))
		assert.Nil(t, req)
		assert.False(t, ok)
	})

	t.Run("should error when malformed token is provided (decode)", func(t *testing.T) {
		req, ok := dec.Decode(OpaqueBytes(strings.Join([]string{method, "c", string("token")}, delimiter)))
		assert.Nil(t, req)
		assert.False(t, ok)
	})
}
