package extjwt

import (
	"net/http"
	"strings"

	"code.justin.tv/common/jwt"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

type extractor struct{}

var extSingleton = &extractor{}

func NewExtractor() auth.Extractor { return extSingleton }

func (*extractor) Method() string { return method }
func (*extractor) Extract(header http.Header) (stream.AuthRequest, bool) {
	clientID := header.Get(protocol.HTTPClientIDHeader)
	auth := header.Get(protocol.HTTPAuthorizationHeader)
	if clientID == "" || !strings.HasPrefix(auth, protocol.HTTPBearerPrefix) {
		return nil, false
	}
	token := OpaqueBytes(auth[len(protocol.HTTPBearerPrefix):])
	if _, err := jwt.Parse(token); err != nil {
		return nil, false
	}
	return NewRequest(clientID, token), true
}

func (*extractor) FailureReason(header http.Header) error {
	clientID := header.Get(protocol.HTTPClientIDHeader)
	auth := header.Get(protocol.HTTPAuthorizationHeader)
	if !strings.HasPrefix(auth, protocol.HTTPBearerPrefix) {
		if auth == "" {
			return stream.ErrMissingAuthorization
		}
		return stream.ErrInvalidAuthHeaders
	}
	if clientID == "" {
		return stream.ErrMissingClientID
	}
	token := auth[len(protocol.HTTPBearerPrefix):]
	if _, err := jwt.Parse([]byte(token)); err != nil {
		return stream.ErrInvalidJWT
	}
	return nil
}
