package extjwt

import (
	"time"

	"code.justin.tv/common/jwt"
)

// NewFakeTokenCreator generates tokens suitable for the vake extjwt validator with a preset
// duration until expiration
func NewFakeTokenCreator(channelID string, listen, send []string, duration time.Duration) func() OpaqueBytes {
	alg := jwt.None
	header := jwt.NewHeader(alg)
	return func() OpaqueBytes {
		cl := &claims{
			ChannelID: channelID,
			Verbs: map[string][]string{
				listenVerb: listen,
				sendVerb:   send,
			},
			Expires: time.Now().Add(duration).Unix(),
		}
		bytes, _ := jwt.Encode(header, cl, alg)
		return OpaqueBytes(bytes)
	}
}
