package extjwt

import (
	"testing"
	"time"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestFakeTokenCreator(t *testing.T) {
	creator := NewFakeTokenCreator("channel", []string{"*"}, []string{"*"}, time.Minute)

	request := NewRequest("client", creator())
	resolver := NewResolver(NewFakeValidator(100, 0, nil))
	creds, err := resolver.Resolve(request)
	require.NoError(t, err)
	require.NotNil(t, creds)
	assert.NotNil(t, creds.Expires())

	addr, err := stream.NewAddress(stream.Namespace("ext"), stream.Version(1), map[string]string{
		"c": "channel",
		"e": "client",
		"a": "*",
	})
	require.NoError(t, err)
	assert.True(t, creds.CanListen(addr))
	assert.True(t, creds.CanSend(addr))
}
