package extjwt

import "math/rand"

type fakeClient struct {
	isValidPct float32
	errPct     float32
	err        error
}

// NewFakeValidator returns a validator that ignores input and returns the same response every time
func NewFakeValidator(isValidPct int, errPct int, err error) Validator {
	return fakeClient{float32(isValidPct) / 100, float32(errPct) / 100, err}.validate
}

func (v fakeClient) validate(clientID string, jwt OpaqueBytes, claims *claims) (bool, error) {
	if rand.Float32() < v.errPct {
		return false, v.err
	}
	return rand.Float32() < v.isValidPct, nil
}
