package extjwt

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
)

func TestFakeValidator(t *testing.T) {
	v := NewFakeValidator(100, 0, nil)
	ok, err := v("", nil, nil)
	assert.True(t, ok)
	assert.NoError(t, err)

	v = NewFakeValidator(0, 0, nil)
	ok, err = v("", nil, nil)
	assert.False(t, ok)
	assert.NoError(t, err)

	v = NewFakeValidator(0, 100, protocol.ErrForbidden)
	ok, err = v("", nil, nil)
	assert.False(t, ok)
	assert.Equal(t, protocol.ErrForbidden, err)
}
