package extjwt

import (
	"net/http"
	"strings"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

const (
	delimiter = "::"
	method    = "extjwt"
)

type request struct {
	clientID string
	jwt      OpaqueBytes
}

func NewRequest(clientID string, jwt OpaqueBytes) stream.AuthRequest {
	return &request{clientID, jwt}
}

func (*request) Method() string { return method }
func (r *request) Encode() OpaqueBytes {
	return OpaqueBytes(strings.Join([]string{method, r.clientID, string(r.jwt)}, delimiter))
}
func (r *request) Inject(header http.Header) (http.Header, error) {
	if r.jwt.IsEmpty() {
		return nil, stream.ErrMissingAuthorization
	}
	if r.clientID == "" {
		return nil, stream.ErrMissingClientID
	}
	header.Set(protocol.HTTPAuthorizationHeader, protocol.HTTPBearerPrefix+string(r.jwt))
	header.Set(protocol.HTTPClientIDHeader, r.clientID)
	return header, nil
}
