package extjwt

import (
	"net/http"
	"strings"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
)

func TestRequest(t *testing.T) {
	token := testToken(&claims{})

	t.Run("should inject headers correctly", func(t *testing.T) {
		req := NewRequest(clientID, token)
		assert.Equal(t, method, req.Method())
		header, err := req.Inject(http.Header{})
		assert.NoError(t, err)
		assert.Equal(t, clientID, header.Get(protocol.HTTPClientIDHeader))
		assert.Equal(t, protocol.HTTPBearerPrefix+string(token), header.Get(protocol.HTTPAuthorizationHeader))
	})

	t.Run("should encode as expected", func(t *testing.T) {
		client := "c"
		req := NewRequest(client, token)
		assert.Equal(t, method, req.Method())
		code := req.Encode()
		assert.Equal(t, OpaqueBytes(strings.Join([]string{method, client, string(token)}, delimiter)), code)
	})

	t.Run("should report a missing clientID", func(t *testing.T) {
		req := NewRequest("", token)
		assert.Equal(t, method, req.Method())
		header, err := req.Inject(http.Header{})
		assert.Nil(t, header)
		assert.Equal(t, stream.ErrMissingClientID, err)
	})

	t.Run("should report a missing token", func(t *testing.T) {
		req := NewRequest(clientID, nil)
		assert.Equal(t, method, req.Method())
		header, err := req.Inject(http.Header{})
		assert.Nil(t, header)
		assert.Equal(t, stream.ErrMissingAuthorization, err)
	})
}
