package extjwt

import (
	"time"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

const (
	listenVerb = "listen"
	sendVerb   = "send"
)

type resolver struct {
	validator Validator
}

func NewResolver(validator Validator) auth.Resolver {
	return &resolver{validator}
}

func (*resolver) Method() string { return method }
func (r *resolver) Resolve(auth stream.AuthRequest) (stream.Credentials, error) {
	req, ok := auth.(*request)
	if !ok {
		return nil, stream.ErrInvalidAuthMethod
	}
	claims, err := parse(req.jwt) // confirm the JWT is well-formed before calling validator
	if err != nil {
		return nil, err
	}

	// we ask validator if the token could listen to a location it has explicitly asked for, which verifies the
	// signature, expiration, etc.
	if _, err = r.validator(req.clientID, req.jwt, claims); err != nil {
		return nil, err
	}

	return payloadToCredentials(req.clientID, claims), nil
}

func payloadToCredentials(clientID string, payload *claims) stream.Credentials {
	return stream.NewTimedCredentials(
		clientID,
		payload.toScopes(clientID, listenVerb),
		payload.toScopes(clientID, sendVerb),
		time.Unix(payload.Expires, 0),
	)
}
