package auth

import (
	"net/http"

	"code.justin.tv/devhub/e2ml/libs/stream"
)

// A Extractor converts HTTP headers into a Request; this process should mirror
// Request.Inject method to provide the ability to push the request over the
// wire. It is designed to support multiple auth methods by returning a boolean
// on successful match of conditions; if no match is possible, the FailureReason
// function can be called to give feedback to the client about what they must
// change.
type Extractor interface {
	Method() string
	Extract(http.Header) (stream.AuthRequest, bool)
	FailureReason(http.Header) error
}
