package fake

import (
	"net/http"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type extractor struct{}

var ext = &extractor{}

// NewExtractor returns a an extractor that always succeeds; since fake
// authorization always returns the same permissions and is never sent over the
// wire there is no precondition that could cause failure.
func NewExtractor() auth.Extractor {
	return ext
}

func (*extractor) Method() string                                        { return method }
func (*extractor) FailureReason(header http.Header) error                { return nil }
func (*extractor) Extract(header http.Header) (stream.AuthRequest, bool) { return req, true }
