package fake

import (
	"net/http"

	"code.justin.tv/devhub/e2ml/libs/stream"
)

const method = "fake"

type request struct{}

var req = &request{}

// NewRequest returns a request that can be used locally but not over the wire;
// this allows fake credentials to be installed on a test or dev service but not
// used as a remote key.
func NewRequest() stream.AuthRequest                     { return req }
func (*request) Method() string                          { return method }
func (*request) Encode() stream.OpaqueBytes              { return stream.OpaqueBytes(method) }
func (*request) Inject(http.Header) (http.Header, error) { return nil, stream.ErrNotImplemented }
