package fake

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type resolver struct {
	creds stream.Credentials
	err   error
}

// NewResolver returns an engine that always returns the input credentials and
// error for any fake request; if the request wasn't created by the fake Extractor the
// call will fail.
func NewResolver(creds stream.Credentials, err error) auth.Resolver {
	return &resolver{creds, err}
}

func (*resolver) Method() string { return method }
func (r *resolver) Resolve(in stream.AuthRequest) (stream.Credentials, error) {
	if in != req {
		return nil, stream.ErrNotImplemented
	}
	return r.creds, r.err
}
