package fake

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestResolver(t *testing.T) {
	res := NewResolver(stream.AllPermissions(), stream.ErrForbidden)
	assert.Equal(t, method, res.Method())

	creds, err := res.Resolve(nil)
	assert.Nil(t, creds)
	assert.Equal(t, stream.ErrNotImplemented, err)

	creds, err = res.Resolve(NewRequest())
	assert.Equal(t, stream.AllPermissions(), creds)
	assert.Equal(t, stream.ErrForbidden, err)
}
