package auth

import "code.justin.tv/devhub/e2ml/libs/stream"

// A Resolver is responsible for converting a Request into stream.Credentials;
// resolvers for each auth method a local Broker wants to support should be
// injected at creation time. The HTTPBroker forwards AuthRequests over the wire
// instead of attempting to analyze them locally, making resolvers unnecessary
// for clients.
type Resolver interface {
	Method() string
	Resolve(stream.AuthRequest) (stream.Credentials, error)
}
