package s2s

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestDecoder_Method(t *testing.T) {
	dec := NewDecoder()
	assert.Equal(t, s2sMethod, dec.Method())
}

func TestDecoder_Decode_ValidToken(t *testing.T) {
	dec := NewDecoder()
	r := newFakeRequest(t, newValidSecret(), "aud-you")

	decodedReq, ok := dec.Decode(r.encodedJWT)
	assert.True(t, ok, "dec.Decode ok")

	req, ok := decodedReq.(*request)
	require.True(t, ok, "request type s2s.Request")
	assert.Equal(t, r.encodedJWT, req.Encode())
	assert.NotNil(t, req.parsedJWT) // keeps parsedJWT for resolver
}

func TestDecoder_Decode_EmptyToken(t *testing.T) {
	dec := NewDecoder()
	decodedReq, ok := dec.Decode(nil)
	assert.False(t, ok, "dec.Decode ok")
	assert.Nil(t, decodedReq)
}

func TestDecoder_Decode_InvalidToken(t *testing.T) {
	dec := NewDecoder()
	decodedReq, ok := dec.Decode(OpaqueBytes("foobar-not-a-jwt"))
	assert.False(t, ok, "dec.Decode ok")
	assert.Nil(t, decodedReq)
}
