package s2s

import (
	"testing"
	"time"

	"code.justin.tv/devhub/e2ml/libs/stream"

	"github.com/stretchr/testify/require"
)

func TestJWTClaims_TimeAsStr(t *testing.T) {
	doomTime := time.Unix(666, 0)
	jwtc := jwtClaims{
		Iat: doomTime.Unix(),
		Exp: doomTime.Unix(),
	}
	require.Equal(t, doomTime, jwtc.ExpAsTime())
	require.Equal(t, doomTime, jwtc.IatAsTime())
}

func TestJWTClaims_ValidateFields(t *testing.T) {
	now := time.Now()
	jwtc := NewJWTClaims(now, "iss-me", "aud-you")

	// valid
	err := jwtc.ValidateFields(now.Add(1*time.Second), "aud-you")
	require.NoError(t, err)

	// expired
	err = jwtc.ValidateFields(now.Add(1000*time.Hour), "aud-you")
	require.Equal(t, stream.ErrAuthExpired, err)

	// different audience
	err = jwtc.ValidateFields(now.Add(1*time.Second), "aud-somebody-else")
	require.Equal(t, stream.ErrAuthAudienceMismatch, err)
}
