package s2s

import (
	"net/http"

	"code.justin.tv/common/jwt"
)

type request struct {
	encodedJWT OpaqueBytes
	parsedJWT  *jwt.Fragment // set when decoding or extracting, to avoid parsing multiple times
}

func (r *request) Method() string      { return s2sMethod }
func (r *request) Encode() OpaqueBytes { return r.encodedJWT }
func (r *request) Inject(h http.Header) (http.Header, error) {
	httpHeadersInject(h, string(r.Encode()))
	return h, nil
}
