package s2s

import (
	"net/http"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestRequest_Method(t *testing.T) {
	req := &request{encodedJWT: []byte("foobar")}
	assert.Equal(t, s2sMethod, req.Method())
}

func TestRequest_Encode(t *testing.T) {
	req := &request{encodedJWT: []byte("foobar")}
	assert.Equal(t, OpaqueBytes("foobar"), req.Encode())
}

func TestRequest_Inject(t *testing.T) {
	req := &request{encodedJWT: []byte("foobar")}

	h := http.Header{}
	h, err := req.Inject(h)
	require.NoError(t, err)
	assert.Equal(t, "Bearer "+string(req.Encode()), h.Get("Authorization"))
}
