package stream

import "fmt"

// flags controlling the behavior of initialization
type AuthMethod byte

const (
	Reservation AuthMethod = 1 // the client has had a slot reserved by a broker; code is a ticket
	Validation  AuthMethod = 2 // the client has not been authorized yet; code is an auth token
)

func (a AuthMethod) IsValid() bool { return a == Reservation || a == Validation }
func (a AuthMethod) String() string {
	switch a {
	case Reservation:
		return "reservation"
	case Validation:
		return "validation"
	default:
		return fmt.Sprintf("unknown{%d}", byte(a))
	}
}

func ParseAuthMethod(auth string) (AuthMethod, error) {
	switch auth {
	case Reservation.String():
		return Reservation, nil
	case Validation.String():
		return Validation, nil
	default:
		return AuthMethod(0), ErrUnsupportedAuthMethod
	}
}
