package stream

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestAuthMethod(t *testing.T) {
	assert.True(t, Reservation.IsValid())
	assert.Equal(t, "reservation", Reservation.String())
	auth, err := ParseAuthMethod(Reservation.String())
	assert.Equal(t, Reservation, auth)
	assert.NoError(t, err)

	assert.True(t, Validation.IsValid())
	assert.Equal(t, "validation", Validation.String())
	auth, err = ParseAuthMethod(Validation.String())
	assert.Equal(t, Validation, auth)
	assert.NoError(t, err)

	var a AuthMethod
	assert.False(t, a.IsValid())
	assert.Equal(t, "unknown{0}", a.String())
	auth, err = ParseAuthMethod(a.String())
	assert.Equal(t, a, auth)
	assert.Equal(t, ErrUnsupportedAuthMethod, err)
}
