package stream

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestCredentialsPromise(t *testing.T) {
	tracker := AllPermissions()
	expected := errors.New("expected")
	s := NewSyncCredentialsPromise(tracker, expected)
	assert.False(t, s.WouldBlock())
	result, err := s.Get()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)
	result, err = s.Result()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)

	a := NewCredentialsPromise()
	assert.True(t, a.WouldBlock())
	a.Set(tracker, expected)
	assert.NotPanics(t, func() {
		a.Set(nil, expected)
		a.Set(nil, nil)
	})
	assert.False(t, a.WouldBlock())
	result, err = a.Get()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)
	result, err = a.Result()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)

	// make sure we're safe for bad cast
	a2 := NewCredentialsPromise().(*asyncCredentials)
	a2.src.Set(false, nil)
	result, err = a2.Result()
	assert.Equal(t, nil, result)
	assert.Equal(t, nil, err)
}
