package history

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestSingleEntry(t *testing.T) {
	addr, err := stream.NewAddress(stream.Namespace("n"), 1, nil)
	require.NoError(t, err)
	t.Run("should initialize", func(t *testing.T) {
		h := NewSingleEntry(addr)
		assert.Equal(t, addr, h.Address())
		src, pos := h.Last()
		assert.Equal(t, stream.None, src)
		assert.Equal(t, stream.Origin, pos)
		msg, ok := h.Next(stream.None, stream.Origin)
		assert.Nil(t, msg)
		assert.False(t, ok)
	})

	t.Run("should report last value", func(t *testing.T) {
		from := stream.SourceID(1)
		seg := stream.Segment{Start: stream.Origin, End: stream.Position(1)}
		msg := stream.NewMessage(addr, from, seg, []byte("hello"))
		h := NewSingleEntry(addr)
		assert.NoError(t, h.Write(msg))
		out, ok := h.Next(stream.None, stream.Origin)
		assert.Equal(t, msg, out)
		assert.True(t, ok)
		src, pos := h.Last()
		assert.Equal(t, from, src)
		assert.Equal(t, seg.End, pos)
	})

	t.Run("should clear values on close", func(t *testing.T) {
		from := stream.SourceID(1)
		seg := stream.Segment{Start: stream.Origin, End: stream.Position(1)}
		msg := stream.NewMessage(addr, from, seg, []byte("hello"))
		h := NewSingleEntry(addr)
		assert.NoError(t, h.Write(msg))
		assert.NoError(t, h.Close())
		msg, ok := h.Next(stream.SourceID(1), stream.Origin)
		assert.Nil(t, msg)
		assert.False(t, ok)
		src, pos := h.Last()
		assert.Equal(t, stream.None, src)
		assert.Equal(t, stream.Origin, pos)
	})
}
