package listener

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type Collection interface {
	Empty()
	IsEmpty() bool
	Add(stream.Listener) bool
	Remove(stream.Listener) bool
	AsSlice() []stream.Listener
}

// Brute force implementation; performance will suffer with high churn or high
// monitor counts.
type collection struct {
	pos   map[stream.Listener]int
	inner []stream.Listener
}

func NewCollection() Collection {
	return &collection{
		pos:   make(map[stream.Listener]int),
		inner: []stream.Listener{},
	}
}

func (c *collection) IsEmpty() bool { return len(c.inner) == 0 }

func (c *collection) Empty() {
	c.pos = make(map[stream.Listener]int)
	c.inner = []stream.Listener{}
}

func (c *collection) Add(listener stream.Listener) bool {
	if _, existed := c.pos[listener]; existed {
		return false
	}
	c.pos[listener] = len(c.inner)
	c.inner = append(c.inner, listener)
	return true
}

func (c *collection) Remove(listener stream.Listener) bool {
	if at, existed := c.pos[listener]; existed {
		delete(c.pos, listener)
		end := len(c.inner) - 1
		if at != end {
			toRemove := c.inner[end]
			c.inner[at] = toRemove
			c.pos[toRemove] = at
		}
		c.inner = c.inner[:end]
		return true
	}
	return false
}

func (c *collection) AsSlice() []stream.Listener {
	return c.inner
}
