package listener

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestCollection(t *testing.T) {
	l1 := NewDevNull()
	l2 := NewDevNull()

	t.Run("initializes correctly", func(t *testing.T) {
		c := NewCollection()
		assert.True(t, c.IsEmpty())
		assert.Equal(t, []stream.Listener{}, c.AsSlice())
	})

	t.Run("adds items correctly", func(t *testing.T) {
		c := NewCollection()
		assert.True(t, c.Add(l1))
		assert.False(t, c.IsEmpty())
		assert.Equal(t, []stream.Listener{l1}, c.AsSlice())

		assert.False(t, c.Add(l1))
		assert.Equal(t, []stream.Listener{l1}, c.AsSlice())

		assert.True(t, c.Add(l2))
		assert.Equal(t, []stream.Listener{l1, l2}, c.AsSlice())
	})

	t.Run("removes items correctly - end position", func(t *testing.T) {
		c := NewCollection()
		assert.True(t, c.Add(l1))
		assert.True(t, c.Add(l2))
		assert.Equal(t, []stream.Listener{l1, l2}, c.AsSlice())

		assert.True(t, c.Remove(l2))
		assert.False(t, c.Remove(l2))
		assert.Equal(t, []stream.Listener{l1}, c.AsSlice())
		assert.False(t, c.IsEmpty())

		assert.True(t, c.Remove(l1))
		assert.False(t, c.Remove(l1))
		assert.Equal(t, []stream.Listener{}, c.AsSlice())
		assert.True(t, c.IsEmpty())
	})

	t.Run("removes items correctly - other positions", func(t *testing.T) {
		c := NewCollection()
		assert.True(t, c.Add(l1))
		assert.True(t, c.Add(l2))
		assert.Equal(t, []stream.Listener{l1, l2}, c.AsSlice())

		assert.True(t, c.Remove(l1))
		assert.False(t, c.Remove(l1))
		assert.Equal(t, []stream.Listener{l2}, c.AsSlice())
		assert.False(t, c.IsEmpty())
	})
}
