package listener

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestDevNull(t *testing.T) {
	addr, err := stream.NewAddress(stream.Namespace("test"), stream.Version(1), map[string]string{})
	require.NoError(t, err)

	mock := NewDevNull()
	src, pos := mock.Current(addr)
	assert.Empty(t, src)
	assert.Empty(t, pos)
	assert.Zero(t, mock.Received())
	assert.Zero(t, mock.Lost())
	assert.Zero(t, mock.Closed())

	msg1 := stream.NewMessage(addr, stream.SourceID(1), stream.Position(2).AsDelta(), []byte("hello"))
	msg2 := stream.NewMessage(addr, stream.SourceID(1), stream.Position(3).AsDelta(), []byte("ok"))
	lost1 := stream.NewLostMessage(addr, stream.SourceID(1), stream.Position(4).AsDelta())

	assert.True(t, mock.OnDataReceived(msg1))
	assert.False(t, mock.OnDataReceived(msg1))
	assert.Equal(t, 1, mock.Received())
	assert.Zero(t, mock.Lost())

	assert.True(t, mock.OnDataReceived(msg2))
	assert.Equal(t, 2, mock.Received())
	assert.Zero(t, mock.Lost())

	assert.True(t, mock.OnDataLost(lost1))
	assert.False(t, mock.OnDataLost(lost1))
	assert.Equal(t, 1, mock.Lost())

	assert.True(t, mock.OnStreamClosed(addr, nil))
	assert.False(t, mock.OnStreamClosed(addr, nil))
	assert.Equal(t, 1, mock.Closed())
}
