package stream

type MessageDescription interface {
	Address() Address
	Source() SourceID
	At() Segment
}

type Message interface {
	MessageDescription
	Data() []byte
}

type simpleMessage struct {
	addr Address
	src  SourceID
	at   Segment
	data []byte
}

func (s *simpleMessage) Address() Address { return s.addr }
func (s *simpleMessage) Source() SourceID { return s.src }
func (s *simpleMessage) At() Segment      { return s.at }
func (s *simpleMessage) Data() []byte     { return s.data }

func NewMessage(addr Address, src SourceID, at Segment, data []byte) Message {
	return &simpleMessage{addr, src, at, data}
}

func NewLostMessage(addr Address, src SourceID, at Segment) MessageDescription {
	return &simpleMessage{addr, src, at, nil}
}
