package stream

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestMessage(t *testing.T) {
	segment := Segment{Start: 1, End: 2}
	src := SourceID(1)
	data := []byte("data")
	addr, err := NewAddress(Namespace("test"), 1, nil)
	require.NoError(t, err)

	desc := NewLostMessage(addr, src, segment)
	assert.Equal(t, addr, desc.Address())
	assert.Equal(t, src, desc.Source())
	assert.Equal(t, segment, desc.At())

	msg := NewMessage(addr, src, segment, data)
	assert.Equal(t, addr, msg.Address())
	assert.Equal(t, src, msg.Source())
	assert.Equal(t, segment, msg.At())
	assert.Equal(t, data, msg.Data())
}
