package protocol

// Message is the base unit of communication for this protocol
type Message interface {
	OpCode() OpCode
	Marshal(ver Version) ([]byte, error)
	Unmarshal(ver Version, bytes []byte) error
	String() string
}

// A Request uses a specific ID that will be given an explicit response (Ack or
// Error) by the recipient
type Request interface {
	Message
	RequestID() RequestID
}
