package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestDrain(t *testing.T) {
	t.Run("should report values correctly", func(t *testing.T) {
		drain, err := NewDrain()
		require.NoError(t, err)
		assert.Equal(t, protocol.Drain, drain.OpCode())
		assert.Equal(t, "<drain>", drain.String())
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		drain, err := NewDrain()
		require.NoError(t, err)
		bytes, err := drain.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, drain, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := createBlank(protocol.Drain).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Drain).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(drainLength, 0),
			createBlank(protocol.Drain).Unmarshal(protocol.Current, []byte{}))
	})
}
