package message

import (
	"fmt"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

const (
	expiringLength = headerLength
)

type Expiring interface {
	protocol.Message
}

type expiringMessage struct{}

var expiringSingleton = &expiringMessage{}

func NewExpiring() (Expiring, error) { return expiringSingleton, nil }

func (*expiringMessage) OpCode() protocol.OpCode { return protocol.Expiring }

func (e *expiringMessage) Marshal(ver protocol.Version) ([]byte, error) {
	if !ver.IsValid() {
		return nil, protocol.ErrInvalidVersion
	}
	bytes := make([]byte, expiringLength)
	injectHeader(bytes, ver, e.OpCode())
	return bytes, nil
}

func (*expiringMessage) Unmarshal(ver protocol.Version, bytes []byte) error {
	if !ver.IsValid() {
		return protocol.ErrInvalidVersion
	}
	total := len(bytes)
	if total != expiringLength {
		return protocol.ErrInvalidLength(expiringLength, total)
	}
	return nil
}

func (e *expiringMessage) String() string {
	return fmt.Sprintf("<%s>", e.OpCode())
}
