package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestExpiring(t *testing.T) {
	t.Run("should report values correctly", func(t *testing.T) {
		expiring, err := NewExpiring()
		require.NoError(t, err)
		assert.Equal(t, protocol.Expiring, expiring.OpCode())
		assert.Equal(t, "<expiring>", expiring.String())
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		expiring, err := NewExpiring()
		require.NoError(t, err)
		bytes, err := expiring.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, expiring, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := createBlank(protocol.Expiring).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Expiring).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(expiringLength, 0),
			createBlank(protocol.Expiring).Unmarshal(protocol.Current, []byte{}))
	})
}
