package marshal

import "code.justin.tv/devhub/e2ml/libs/stream/protocol"

// nullCache implements Cache but doesn't actually save values. Useful for
// debugging.
type nullCache struct {
	src MarshalFunc
	ver protocol.Version
}

var _ Cache = (*nullCache)(nil)

func NewNullCache(src MarshalFunc, ver protocol.Version) Cache {
	return &nullCache{src, ver}
}

func (n *nullCache) Get() ([]byte, error) { return n.src(n.ver) }
