package marshal

import (
	"errors"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
)

func TestNullCache(t *testing.T) {
	data := newMarshalTestData([]byte("result"), errors.New("expected"))
	cache := NewNullCache(data.call, protocol.Unknown)
	value, err := cache.Get()
	assert.Equal(t, data.value, value)
	assert.Equal(t, data.err, err)
	assert.Equal(t, 1, data.called)
	value, err = cache.Get()
	assert.Equal(t, data.value, value)
	assert.Equal(t, data.err, err)
	assert.Equal(t, 2, data.called)
}
