package marshal

import (
	"sync"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

// onceCache implements Cache by using sync.Once
// debugging.
type onceCache struct {
	src   MarshalFunc
	ver   protocol.Version
	once  sync.Once
	value []byte
	err   error
}

var _ Cache = (*onceCache)(nil)

func NewOnceCache(src MarshalFunc, ver protocol.Version) Cache {
	return &onceCache{src: src, ver: ver}
}

func (o *onceCache) Get() ([]byte, error) {
	o.once.Do(o.exec)
	return o.value, o.err
}

func (o *onceCache) exec() {
	o.value, o.err = o.src(o.ver)
}
