package marshal

import (
	"errors"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
)

type marshalTestData struct {
	called int
	value  []byte
	err    error
}

func newMarshalTestData(value []byte, err error) *marshalTestData {
	return &marshalTestData{value: value, err: err}
}

func (m *marshalTestData) call(ver protocol.Version) ([]byte, error) {
	m.called++
	return m.value, m.err
}

func TestOnceCache(t *testing.T) {
	data := newMarshalTestData([]byte("result"), errors.New("expected"))
	cache := NewOnceCache(data.call, protocol.Unknown)
	value, err := cache.Get()
	assert.Equal(t, data.value, value)
	assert.Equal(t, data.err, err)
	assert.Equal(t, 1, data.called)
	value, err = cache.Get()
	assert.Equal(t, data.value, value)
	assert.Equal(t, data.err, err)
	assert.Equal(t, 1, data.called)
}
