package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
)

func TestInjectHeader(t *testing.T) {
	t.Run("should inject values correctly", func(t *testing.T) {
		header := make([]byte, headerLength)
		assert.True(t, injectHeader(header, protocol.Current, protocol.Init))
		assert.EqualValues(t, protocol.Current, header[2])
		assert.EqualValues(t, protocol.Init, header[3])
	})

	t.Run("should report failure if there is not enough space", func(t *testing.T) {
		assert.False(t, injectHeader([]byte{}, protocol.Current, protocol.Init))
	})
}

func TestExtractHeader(t *testing.T) {
	t.Run("should extract values correctly", func(t *testing.T) {
		ver, op, ok := extractHeader([]byte{'S', 't', byte(protocol.Current), byte(protocol.Init)})
		assert.True(t, ok)
		assert.Equal(t, ver, protocol.Current)
		assert.Equal(t, op, protocol.Init)
	})

	t.Run("should report failure if there is not enough space", func(t *testing.T) {
		_, _, ok := extractHeader([]byte{})
		assert.False(t, ok)
	})

	t.Run("should report failure if magic doesn't match", func(t *testing.T) {
		_, _, ok := extractHeader([]byte{'S', 'T', byte(protocol.Current), byte(protocol.Init)})
		assert.False(t, ok)
	})
}
