package protocol

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestOpCode(t *testing.T) {
	assert.False(t, Invalid.IsFromClient())
	assert.False(t, Invalid.IsFromService())
	assert.True(t, Send.IsFromClient())
	assert.True(t, Ack.IsFromService())
	assert.Equal(t, "ack", Ack.String())
	assert.Equal(t, "unknown: 1", OpCode(1).String())
}
