package protocol

// RequestID is used to track ack or nack of individual requests; it is designed
// to have a short validity and the same value may be reused over time. Clients
// should explire association on a timeout and treat unacknowleged sigals as
// failures. Since the value is used for client tracking, collisions across
// clients are virtually guaranteed and this should always be stored with a
// unique client identifier or connection on the service side.
type RequestID uint16

const (
	NoRequest      = RequestID(0) // for cases where the signal was not requested
	FirstRequest   = RequestID(1)
	InvalidRequest = RequestID(2) // useful for testing
)

// Next allows a safe sequence that wraps without ever returning NoRequest
func (r RequestID) Next() RequestID { return r + 2 }

// IsValid returns true if this is a valid RequestID (NoRequest returns false)
func (r RequestID) IsValid() bool { return r&1 != 0 }
