package protocol

// Version tracks which message format and supported commands to use for each
// client.  Backward compatibility is maintained by downgrading communications
// on the service side to match the requested protocol. This is different from
// stream.Version, which is used to specify the format of the namespace specific
// content that is being served by this generic protocol.
type Version byte

const (
	Unknown = Version(0) // zero value invalid
	Four    = Version(4)
	Five    = Version(5)
	Current = Five
)

func (v Version) IsValid() bool { return v == Four || v == Five }
