package stream

import "code.justin.tv/devhub/e2ml/libs/promise"

// A Reader represents an origin point for streaming data; listeners can
// join or leave it to turn notifications on and off for the given address. The
// join/leave funtions return true if the listener's status changed, false if
// the request was redundant
type Reader interface {
	Address() Address
	Join(listener Listener) promise.Bool // listener is responsible for reporting its Position
	Leave(listener Listener) promise.Bool
}
