package registry

import "code.justin.tv/devhub/e2ml/libs/stream/protocol"

type requestList struct {
	current map[protocol.RequestID]responseFunction
	old     map[protocol.RequestID]responseFunction
}

func newRequestList() *requestList {
	return &requestList{
		make(map[protocol.RequestID]responseFunction),
		make(map[protocol.RequestID]responseFunction),
	}
}

func (r *requestList) tick() map[protocol.RequestID]responseFunction {
	expired := r.old
	r.old = r.current
	r.current = make(map[protocol.RequestID]responseFunction)
	return expired
}

func (r *requestList) set(key protocol.RequestID, value responseFunction) {
	r.current[key] = value
}

func (r *requestList) get(key protocol.RequestID) (responseFunction, bool) {
	if value, ok := r.current[key]; ok {
		delete(r.current, key)
		return value, true
	}
	if value, ok := r.old[key]; ok {
		delete(r.old, key)
		return value, true
	}
	return nil, false
}
