package registry

import (
	"sync"

	"code.justin.tv/devhub/e2ml/libs/stream"
)

type writer struct {
	inner  *channel
	closed bool
	mutex  sync.RWMutex
}

var _ stream.Writer = (*writer)(nil)

func newWriter(ch *channel) *writer { return &writer{inner: ch} }

func (w *writer) Close() error {
	w.mutex.Lock()
	closed := w.closed
	w.closed = true
	w.mutex.Unlock()
	if closed {
		return stream.ErrWriterAlreadyClosed
	}
	return w.inner.closeWriter(w)
}

func (w *writer) Address() stream.Address { return w.inner.Address() }
func (w *writer) Send(message []byte, isDelta bool) stream.TrackerPromise {
	w.mutex.RLock()
	defer w.mutex.RUnlock()
	if w.closed {
		return stream.NewSyncTrackerPromise(stream.Untracked, stream.ErrWriterAlreadyClosed)
	}
	return w.inner.send(message, isDelta)
}
