package scheduler

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/history"
	"code.justin.tv/devhub/e2ml/libs/stream/listener"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestInline(t *testing.T) {
	addr, err := stream.NewAddress(stream.Namespace("test"), stream.Version(1), map[string]string{})
	require.NoError(t, err)

	inline := NewInline()
	h := history.NewSingleEntry(addr)
	l1 := listener.NewDevNull()
	l2 := listener.NewDevNull()
	dest := []stream.Listener{l1, l2}

	count, err := inline.Update(h, stream.Origin, dest)
	assert.NoError(t, err)
	assert.Empty(t, count)
	assert.Empty(t, l1.Lost())
	assert.Empty(t, l1.Received())
	assert.Empty(t, l1.Closed())
	assert.Empty(t, l2.Lost())
	assert.Empty(t, l2.Received())
	assert.Empty(t, l2.Closed())

	require.NoError(t, h.Write(stream.NewMessage(addr, stream.SourceID(1), stream.Position(2).AsDelta(), []byte("hello"))))
	count, err = inline.Update(h, stream.Position(3), dest)
	assert.NoError(t, err)
	assert.Equal(t, 10, count)
	assert.Equal(t, 2, l1.Lost())
	assert.Equal(t, 2, l2.Lost())
	assert.Equal(t, 1, l1.Received())
	assert.Equal(t, 1, l2.Received())

	assert.NoError(t, inline.SetClosed(addr, nil, dest))
	assert.Equal(t, 1, l1.Closed())
	assert.Equal(t, 1, l2.Closed())
}
