package scheduler

import "code.justin.tv/devhub/e2ml/libs/stream"

// Update pushes an arbitrary history into an arbitrary listener
func Update(history stream.History, lost stream.Position, listener stream.Listener) (int, error) {
	addr := history.Address()
	src, pos := listener.Current(addr)
	written := 0
	for msg, ok := history.Next(src, pos); ok; msg, ok = history.Next(src, pos) {
		at := msg.At()
		if at.Start > pos && (src == stream.None || src == msg.Source()) {
			lost := stream.NewLostMessage(msg.Address(), msg.Source(), stream.Segment{Start: pos, End: at.Start})
			if !listener.OnDataLost(lost) {
				return written, nil
			}
		}
		if !listener.OnDataReceived(msg) {
			return written, nil
		}
		written += len(msg.Data())
		prev := pos
		src, pos = listener.Current(addr)
		if prev == pos {
			return written, stream.ErrNoProgress
		}
	}
	// TODO : evaluate necessity of this check
	from, last := history.Last()
	if from == src && lost > last {
		listener.OnDataLost(stream.NewLostMessage(addr, src, stream.Segment{Start: last, End: lost}))
	}
	return written, nil
}
